package gov.va.genisis2.dao.impl;

import static org.springframework.ldap.query.LdapQueryBuilder.query;
import gov.va.genisis2.dao.ILdapStudyApprovalDAO;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.vo.LdapStudyApproval;
import gov.va.genisis2.vo.LdapStudyApprovalGroup;

import java.util.ArrayList;
import java.util.List;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class LdapStudyApprovalDAO implements ILdapStudyApprovalDAO {

	private static final Logger LOGGER = LoggerFactory.getLogger(LdapStudyApprovalDAO.class);

	private static final String LDAP_SA_BASE = "ou=Groups";
	private static final String LDAP_SA_FILTER = "objectClass";
	private static final String LDAP_SA_CLASS_TYPE = "posixGroup";
	private static final String LDAP_SA_ATTR_CN = "cn";

	@Autowired
	private LdapTemplate ldapTemplate;

	
	public List<LdapStudyApprovalGroup> getAllLdapStudyApproval() throws GenisisDAOException {
		List<LdapStudyApprovalGroup> ldapStudyApprovalGroups;
		try {
			ldapStudyApprovalGroups = ldapTemplate.search(query().base(LDAP_SA_BASE).where(LDAP_SA_FILTER).is(LDAP_SA_CLASS_TYPE), new StudyApprovalsAttributesMapper());
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on getAllStudyApprovals.", ex);
			throw new GenisisDAOException("Exception occurred on getAllStudyApprovals.", ex);
		}
		return ldapStudyApprovalGroups;
	}


	private class StudyApprovalsAttributesMapper implements AttributesMapper<LdapStudyApprovalGroup> {
		@Override
		public LdapStudyApprovalGroup mapFromAttributes(Attributes attrs) throws NamingException {
			List<StudyApproval> listStudyApproval = new ArrayList<>();
			LdapStudyApprovalGroup ldapGroup = new LdapStudyApprovalGroup();
			ldapGroup.setGroupName((String) attrs.get(LDAP_SA_ATTR_CN).get());
			ldapGroup.setLdapStudyApprovals(listStudyApproval);
			
			return ldapGroup;
		}

	}
}
